package easik.ui.tree.popup;

import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;

import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;

import easik.Easik;
import easik.sketch.attribute.AttributeUI;
import easik.sketch.attribute.EntityAttribute;
import easik.sketch.datatype.DataType;
import easik.sketch.vertex.EntityNode;


/**
 * Edit attribute popup menu action for the information tree.
 * 
 * @author Kevin Green 2006
 * @since 2006-06-14 Kevin Green
 * @version 2006-07-26 Kevin Green
 */
public class EditAttributeAction extends AbstractAction {	
	
	/**
	 *	Set up the edit attribute menu option.
	 */
	public EditAttributeAction() {
		super("Edit Attribute");
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Edits the currently selected attribute.");		
	}
	
	/**
	 * Brings up a dialog to edit the currently selected attribute
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		//If there is nothing seleceted then just do nothing
		if(Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().isSelectionEmpty())
		{
			return;
		}
	
		//Get currently selected object
		DefaultMutableTreeNode curSelectedNode = (DefaultMutableTreeNode) 
					Easik.getInstance().getFrame().getInfoTreeUI().getInfoTree().getSelectionPath().getLastPathComponent();
		Object curSelected = curSelectedNode.getUserObject();
		
		//Selection is an attribute
		if(curSelected.getClass() == EntityAttribute.class){
			DefaultMutableTreeNode entityNode = (DefaultMutableTreeNode) curSelectedNode.getParent();
			EntityNode parentEntity = (EntityNode) entityNode.getUserObject();
			
			EntityAttribute curAttribute = (EntityAttribute) curSelected;
			
			AttributeUI myUI = new AttributeUI(curAttribute);
			
			if(myUI.getExit())
			{
				//Get values from dialog
				String newAttName = myUI.getAttName();
				DataType newAttType = myUI.getAttType();
				
				if(newAttName.equals(curAttribute.getName()) || (!EntityAttribute.isAttNameUsed(parentEntity, newAttName) && !EntityAttribute.isProtectedName(parentEntity, newAttName))){
					curAttribute.setName(newAttName);
					curAttribute.setDataType(newAttType);
				}
				else
				{
					if(EntityAttribute.isAttNameUsed(parentEntity, newAttName)){
					//Pop up error dialog
						JOptionPane.showMessageDialog(Easik.getInstance().getFrame(), 
								"There is already an attribute with that name. \nPlease try again.",
								"Attribute Already Exists", JOptionPane.ERROR_MESSAGE);
					}
					else{
						JOptionPane.showMessageDialog(Easik.getInstance().getFrame(), 
								"The entered name is protected.\nPlease try again.",
								"Name Protected", JOptionPane.ERROR_MESSAGE);
					}
				}
				Easik.getInstance().getFrame().getInfoTreeUI().refreshTree(entityNode);
				
				Object[] myCell = new Object[1];
				myCell[0] = Easik.getInstance().getFrame().getSketch().getAdapter().getVertexCell(parentEntity);
				Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().hideCells(myCell, true);
				Easik.getInstance().getFrame().getSketch().getGraphLayoutCache().showCells(myCell, true);
				Easik.getInstance().getFrame().getSketch().repaint();
				
				Easik.getInstance().getFrame().getSketch().setDirty(true);
			}			
		}
		
		//Selection is not an attribute
		else{ 
			JOptionPane.showMessageDialog(Easik.getInstance().getFrame(),
					"You don't have an attribute selected. \nPlease select an attribute and try again.",
					"No Attribute Selected", JOptionPane.ERROR_MESSAGE);
		}
	}
}
